<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ta1="http://www.sec.gov/edgar/ta/taonefiler">
	<xsl:import href="util.xsl" />
	<xsl:output method="html" indent="no" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:variable name="submissionType"
		select="ta1:edgarSubmission/ta1:headerData/ta1:submissionType" />
	<xsl:variable name="schemaVersion" select="ta1:edgarSubmission/ta1:schemaVersion" />

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
				<style type="text/css">

					.warning {
					font-weight:bold;
					padding:10px;
					margin:5px 0px;
					font-size:0.9em;
					}
					/* informations */
					.information, .informationNoBorder {
					font-weight:lighter
					padding:10px;
					color:#302000;
					font-size:0.9em;
					}
					img {
					vertical-align:text-top;
					}
					.information {
					margin:5px 0px;
					}
					.informationNoBorder{
					margin:5px 0px;
					}
					/* titles (order by font size)*/
					.title1, .title2, .title3,
					.titleNumber {
					font-family: Arial, Helvetica, sans-serif;
					text-align: left;
					line-height: 1.5;
					}
					.title1 { /* Largest title */
					margin: 10px 0px;
					font-size: 1.3em;
					}
					.title2 { /* Second largest title */
					margin: 10px;
					font-size: 1.1em;
					}
					.title3 { /* Third largest title */
					margin: 10px 20px;
					color: black;
					font-size: 1.0em;
					}
					.titleNumber {
					margin: 10px 0px;
					line-height: 0.8;
					}
					.titleWhite {
					background-color: white;
					width: 25%;
					}
					h4{
					vertical-align:middle;
					}
					.pageHeader {
					font-weight:bold;
					padding:10px;
					margin:5px 0px;
					background-color:#e0e0ff;
					border:2px solid #42638F;
					color:#302000;
					text-align: center;
					vertical-align: middle;
					}
					#pageHeaderTitle {
					font-size:1.2em;
					}
					#pageHeaderDetail {
					font-size:1.1em;
					}
					#pageHeaderQuestion{
					font-weight:lighter;
					font-size:1.0em;
					}
					#twoHeaders .title1, .title2{
					display:inline;
					}
					#pageHeaderTitleOMB{
					font-size:1.0em;
					}
					#pageHeaderOMBNumber {
					font-size:0.9em;
					}
					#pageHeaderOMBEst {
					font-size:0.8em;
					}
					#ombHeaderTable {
					border-collapse: collapse;
					border:2px solid #42638F;
					}
					#ombHeaderTable td {
					vertical-align: middle;
					}
					#header .side {
					font-weight:lighter;
					}
					.fakeBox {
					border-top: 2px solid #999;
					}
					ul{
					padding-left:10px;
					padding-right:10px;
					}
					.fakeBox_drp1_duration{
					display:inline-block;
					border-top: 2px solid #999;
					border-right: 1px solid #ccc;
					border-bottom: 1px solid #ccc;
					border-left: 2px solid #999;
					padding: 2px;
					min-width: 40px;
					width: 40px;
					height: 15px;
					word-wrap: break-word;
					font-size: 0.9em;
					color: blue;
					}
				</style>
			</head>
		</html>
		<xsl:apply-templates select="ta1:edgarSubmission/ta1:headerData/ta1:filerInfo" />
		<xsl:apply-templates select="ta1:edgarSubmission" />
	</xsl:template>

	<!-- Header Template START -->
	<xsl:template name="header"
		match="ta1:edgarSubmission/ta1:headerData/ta1:filerInfo">
		<div id="info">
			<div class="contentwrapper">
					<table role="presentation" id="header">
						<tr>
							<td class="title">Form TA-1 Filer Information</td>
							<td rowspan="2" class="center">			
									<br/>
									UNITED STATES
									<br/>
									SECURITIES AND EXCHANGE COMMISSION
									<br/>
									Washington, D.C. 20549
									<br/><br/>
									FORM <xsl:value-of select="$submissionType" />											
							</td>
							<td class="title">OMB APPROVAL</td>
						</tr>
						<tr>
						   <td class="side" style="text-align: center;">
									<p>
										<br />
										FORM <xsl:value-of select="$submissionType" />
										<br />
									</p>
							</td>
							<td
									width="25%"
									class="side">
							
									<p>OMB Number:&#160;&#160; 3235-0084</p>
									<hr></hr>
									<p>Estimated average burden hours per response: 1.5</p>
							</td>
						</tr>
					</table>
				<div class="content">
					<h1>
						<xsl:value-of select="$submissionType" />
						: Filer Information
					</h1>
					<table>
						<tr class="primaryVeryDark" style="MIN-HEIGHT: 27px">
							<td
								style="PADDING-RIGHT: 1px; PADDING-LEFT: 1px; PADDING-BOTTOM: 1px; VERTICAL-ALIGN: middle; BORDER-TOP-STYLE: none; PADDING-TOP: 1px; BORDER-BOTTOM: 5pt solid; BORDER-RIGHT-STYLE: none; BORDER-LEFT-STYLE: none; BACKGROUND-COLOR: #003366">
								<div style="MARGIN-TOP: 0px" align="left">
									<xsl:if test="$schemaVersion != ''">
										<font face="Verdana" color="#ffffff">
											Form Version
											<span class="xdExpressionBox xdDataBindingUI" title=""
												tabIndex="-1"
												style="BORDER-RIGHT: #dcdcdc 1pt; BORDER-TOP: #dcdcdc 1pt; MARGIN-TOP: 0px; MARGIN-BOTTOM: 0px; PADDING-BOTTOM: 0px; BORDER-LEFT: #dcdcdc 1pt; WIDTH: 104px; PADDING-TOP: 0px; BORDER-BOTTOM: #dcdcdc 1pt">
												<xsl:value-of select="$schemaVersion" />
											</span>
										</font>
									</xsl:if>
								</div>
							</td>
							<td
								style="PADDING-RIGHT: 1px; PADDING-LEFT: 1px; PADDING-BOTTOM: 1px; VERTICAL-ALIGN: middle; BORDER-TOP-STYLE: none; PADDING-TOP: 1px; BORDER-BOTTOM: 5pt solid; BORDER-RIGHT-STYLE: none; BORDER-LEFT-STYLE: none; BACKGROUND-COLOR: #003366">
							</td>
						</tr>
					</table>
					<table role="presentation" class="filerInformation">
						<tr>
							<td>

							</td>
						</tr>
						<tr>
							<td class="label">
								<font face="Times New Roman">
									<b>1(a).</b>
								</font>
								Filer CIK:
							</td>
							<td>
								<div class="fakeBox2" style="margin-top:5px">
								<xsl:call-template name="CIKLink" >
									<xsl:with-param name="aCIK" select="ta1:filer/ta1:filerCredentials/ta1:cik"></xsl:with-param>
									<xsl:with-param name="label" select="ta1:filer/ta1:filerCredentials/ta1:cik"></xsl:with-param>									
								</xsl:call-template>
								</div>	
							</td>
						</tr>
						<tr>
							<td class="label">
								<font face="Times New Roman">
									<b>1(b).</b>
								</font>
								Filer CCC:
							</td>
							<td>
								<div class="fakeBox2" style="margin-top:5px">
									********
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(c).</font>
								</b>
								Is this a LIVE or TEST submission?
							</td>
							<td>
									<xsl:choose>
										<xsl:when test="ta1:liveTestFlag = 'LIVE'">
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									&#160;Live&#160;
									<xsl:choose>
										<xsl:when test="ta1:liveTestFlag = 'TEST'">
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									&#160;Test
							</td>
						</tr>
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(d).</font>
								</b>
								Would you like a Return Copy?
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="ta1:flags/ta1:returnCopyFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;Yes&#160;
							</td>
						</tr>
						<tr>	
							<td class="label">
								<b>
									<font face="Times New Roman">1(e).</font>
								</b>
								Is this filing an amendment to a previous filing? 
							</td>						
							<td>
								<xsl:choose>
									<xsl:when test=" $submissionType = 'TA-1/A' ">
										<img src="Images/box-checked.jpg" alt="checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>		
								&#160;Yes&#160;
							</td>						
						</tr>
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(e)(i).</font>
								</b>
								File Number:
							</td>
							<td>
								<div class="fakeBox2">
									<xsl:call-template name="FileNoLink" >
										<xsl:with-param name="aFileNumber" select="ta1:filer/ta1:fileNumber"></xsl:with-param>
										<xsl:with-param name="label" select="ta1:filer/ta1:fileNumber"></xsl:with-param>									
									</xsl:call-template>
								</div>
							</td>
						</tr>						
										
						
					</table>	
					<p></p>
						
			      <h3>Submission Contact Information</h3>
			      <p></p>
					The registrant may provide a single e-mail address for contact purposes.
					<p></p>
					<table role="presentation">
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(f)(i).</font>
								</b>
								Contact Name:
							</td>
							<td>
								<div class="fakeBox">
									<font face="Times New Roman">
										<xsl:value-of select="ta1:contact/ta1:contactName" />
									</font>
								</div>
							</td>
						</tr>					
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(f)(ii).</font>
								</b>
								Contact Phone Number:
							</td>
							<td>
								<div class="fakeBox2">
									<font face="Times New Roman">
										<xsl:value-of select="ta1:contact/ta1:contactPhoneNumber" />
									</font>
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(f)(iii).</font>
								</b>
								Contact E-Mail Address:
							</td>
							<td>
								<div class="fakeBox">
									<font face="Times New Roman">
										<xsl:value-of select="ta1:contact/ta1:contactEmailAddress" />
									</font>
								</div>
							</td>
						</tr>
						</table>
						<p></p>
						<h3>Notification Information</h3>
						<p></p>
						The registrant may provide additional e-mail addresses for those persons 
						the filer would like to receive notification e-mails regarding the filing.
						<p></p>
						<table role="presentation">						
						<tr>
							<td class="label">
								<b>
									<font face="Times New Roman">1(g).</font>
								</b>
								Notification E-mail Address:
							</td>
							<td>
								<xsl:for-each
									select="ta1:notifications/ta1:internetNotificationAddress">
									<div class="fakeBox">
										<font face="Times New Roman">
											<xsl:value-of select="." />
										</font>
									</div>
									<br />
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>

	<xsl:template name="formData" match="ta1:edgarSubmission">
		<xsl:call-template name="item1_registration" />
		<xsl:call-template name="item2_independentRegistrantInfo" />
		<xsl:call-template name="item3_applicantAffiliateDiscHistoryInfo" />
		<xsl:call-template name="item4_signature" />
	</xsl:template>

	<xsl:include href="TA-1_item1.xsl" />
	<xsl:include href="TA-1_item2.xsl" />
	<xsl:include href="TA-1_item3.xsl" />
	<xsl:include href="TA-1_item4.xsl" />
	<xsl:include href="SDR_State_Codes.xsl" />
</xsl:stylesheet>
